<?php  

include  'db.php'; 


header('Content-Type: application/json');


$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody, true);

 $purchaseid =$data['purchaseid']; 

 if (empty($purchaseid)) {
    echo json_encode(['error' => 'purchase ID is required']);
    exit();
}


     $sql="SELECT *   FROM purchase_data     where purchase_id=  '$purchaseid' AND Delete_status = 0  ";

	  $sqlexecute = mysqli_query($conn, $sql); 

	

if (!$sqlexecute) {

    echo json_encode(['error' => 'Failed to execute query: ' . mysqli_error($conn)]);

    exit();

}



$orders = [];

$taxvalues = []; 


while ($row = mysqli_fetch_assoc($sqlexecute)) {

    $productid = $row['Product_id'];
    $productQuery = "SELECT Product_id, Product_name FROM product WHERE Product_id = '$productid' AND Delete_status = 0";
    $productResult = mysqli_query($conn, $productQuery);

    if (!$productResult) {
        echo json_encode(['error' => 'Failed to fetch product data: ' . mysqli_error($conn)]);
        exit();
    }
    $product = mysqli_fetch_assoc($productResult);
    $productname = $product['Product_name'] ?? 'Unknown Product';

    $mrp = $row['MRP'];
    $saleprice = $row['Selling_price'];
    $price = '';
    $discountvalue = $row['discount'];
    $discountpercentage = $row['Discount_percentage'];
    $qty = $row['qty'];
    $amount = $row['product_total'];
    $taxvalue = $row['Tax'];
    $taxpercentage = $row['Tax_percentage'];
    $sale_price_tax = $row['salepricetax'];



    $orders[] = [

        'productid' => $productid,
        'productname' => $productname,
        'mrp' => $mrp,
        'saleprice' => $saleprice,
        'price' => $price,
        'discountvalue' => $discountvalue,
        'discountpercentage' => $discountpercentage,
        'qty' => $qty,
        'amount' => $amount,
        'taxvalue' => $taxvalue,
        'taxpercentage' => $taxpercentage,
        'salepricetax' => $sale_price_tax

    ];

    $taxvalues[] = $taxvalue;

}



$invoiceHtml = '';

foreach ($orders as $order) {

    $invoiceHtml .="<tr class='align-items-top'>

        <td class='align-items-top productname'>

            {$order['productname']}

            <input type='hidden' id='productid' class='productid' name='productid[]' value='{$order['productid']}'>
  <input type='hidden' id='salepricetax' class='salepricetax' name='salepricetax[]' value='{$order['salepricetax']}'>
        </td>

        <td>

            <button type='button' name='remove' id='removeicon' class='' style='color:blue; font-weight:300; top: -100px; border:none;'>

                <i class='dw dw-cancel'></i>

            </button>

        </td>

        <td></td>

        <td class='align-items-top'>

            <input type='text' name='mrp[]' class='invTable mrp' value='{$order['mrp']}'>

        </td>

        <td class='align-items-top'>

            <input type='text' class='invTable price' name='price[]' value='{$order['price']}'>

        </td>

        <td class='align-items-top'>

            <input type='text' class='invTable discountvalue' name='discountvalue[]' value='{$order['discountvalue']}'>

            <br>

            <div style='position: relative; display: inline-block;'>

                <input class='invTable discountpercentage' name='discountpercentage[]' value='{$order['discountpercentage']}' style='margin-top:5px;' type='text'>

                <span style='position: absolute; right: 5px; top: 50%; transform: translateY(-50%); font-weight: bold;'>%</span>

            </div>

        </td>

        <td class='align-items-top'>

            <input type='text' class='invTable qty' name='qty[]' value='{$order['qty']}'>

        </td>

        <td class='align-items-top'>

            <div style='position: relative; display: inline-block;'>

                <input type='text' name='taxpercentage[]' class='invTable taxpercentage' value='{$order['taxpercentage']}' style='padding-right: 20px; box-sizing: border-box;'>

                <span style='position: absolute; right: 5px; top: 50%; transform: translateY(-50%); font-weight: bold;'>%</span>

            </div>

            <br>

            <span class='taxvalue'>₹" . number_format($order['taxvalue'], 2) . "</span>

        </td>

        <td></td>

        <td class='align-items-top amountspan'>" . number_format($order['amount'], 2) . "</td>

    </tr>";

}



echo json_encode(['invoiceHtml' => $invoiceHtml, 'taxValues' => $taxValues]);

mysqli_close($conn);

?>

